@extends('layouts.vendor')
@section('content')
<div class="col-9 main-dash-left">
    <div class="analytics">
        <div class="main-notification-messege">
            <div class="calender-manage-all">
                <h3 class="head-calender-manage">Calendar management</h3>
                <div class="row">
                    <div class="col-md-6">
                        <div class="inner-text-calender-right">
                            <div class="container text-center">
                                <div id="datepicker"></div>
                            </div>
                        </div>
                    </div>
            
                    <div class="col-md-6">
                        <div class="main-set-avail">
                            <div class="head-set-avail d-flex">
                                <h6>Set Unavailability</h6>
                                <h6 id="selected-date-label">Select a date</h6>
                            </div>
            
                            <div class="upper-form-date-form">
                                <div id="availability-slots-container">
                                </div>
                                
                                <button type="button" id="add-slot-btn" class="btn btn-secondary mb-3">
                                    <i class="fa-solid fa-plus"></i> Add Slot
                                </button>
                                
                                <div class="clos-ull">
                                    <div class="form-check main-clos">
                                        <input class="form-check-input" type="checkbox" id="full-day-close">
                                        <label class="form-check-label" for="full-day-close">Close for full day</label>
                                    </div>
                                </div>
                                
                                <input type="hidden" id="selected-date" name="date">
                                <button type="button" id="save-availability-btn" class="add-user">Save</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="sownload-cv-pdf">
                <button class="download-pdf">Download PDF</button>
                <button class="download-pdf">Download CSV</button>
            </div>
            <div class="notifi-list d-flex">
                <h6>Pick Up/Drop Off</h6>
                <div class="dropdowns-inner-list d-flex">
                    <div class="dropdowns-inner-list">
                        <div class="icon-search-main">
                            <i class="fa-solid fa-magnifying-glass"></i>
                            <input aria-describedby="passwordHelpBlock" placeholder="Search For User" type="text" id="inputPassword5" class="form-control" value="">
                        </div>
                    </div>
                    <div class="filter-main-div">
                        <p class="lable-filt">Filter:</p>
                        <div class="dropdown">
                            <button class="filter-btn dropdown-toggle" type="button" id="productFilterDropdown" 
                                    data-bs-toggle="dropdown" aria-expanded="false">
                                <i class="fa-solid fa-filter"></i> Filter
                            </button>
                            <ul class="dropdown-menu" aria-labelledby="productFilterDropdown">
                                <li><a class="dropdown-item filter-product" href="#" data-product="all">All Products</a></li>
                                @foreach($uniqueProducts as $product)
                                    <li><a class="dropdown-item filter-product" href="#" data-product="{{ $product }}">{{ $product }}</a></li>
                                @endforeach
                            </ul>
                        </div>
                    </div>

                    
                </div>
            </div>
            <div class="notification-table pt-0">
                <table id="bookingTable"class="table">
                    <thead>
                        <tr class="head-class-td">
                            <th>Booking ID</th>
                            <th>Client Name</th>
                            <th>Phone Number</th>
                            <th>Email</th>
                            <th>Customer's Date/Time Changes</th>
                            <th>Customer's Reason</th>
                            <th>Pick-Up Date /Time</th>
                            <th>Drop-Off Date /Time</th>
                            <th>New Drop-Off Date /Time</th>
                            <th>Action</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                    
                </table>
            </div>
        </div>
        </div>
    </div>
</div>


<div class="modal fade modal-delete-logout" id="statusChangeModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="p-0 modal-body">
                <div class="inner-body-delete-logout">
                    <h4 id="statusChangeModalText">Are you sure you want to change the booking status?</h4>
                    <div class="upper-btns-modal-pair">
                        <button type="button" data-bs-dismiss="modal" class="comn-modal-btns-transparent btn btn-primary">No</button>
                        <form id="statusChangeForm" method="POST" action="">
                            @csrf
                            <input type="hidden" name="status" id="newStatusValue">
                            <button type="submit" class="comn-modal-btns-blue btn btn-primary">Yes</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade modal-delete-logout" id="deleteProduct" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="deleteProductModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="p-0 modal-body">
                <div class="inner-body-delete-logout">
                    <h4 id="delete-text">Are you sure you want to delete this slot?</h4>
                    <div class="upper-btns-modal-pair">
                        <button type="button" data-bs-dismiss="modal" class="comn-modal-btns-transparent btn btn-primary">No</button>
                        <form id="delete-product-form" method="POST">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="comn-modal-btns-blue add-user">Yes</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Slot Template (Hidden) -->
<div id="slot-template" class="row mb-3 slot-row" style="display: none;" data-slot-id="">
    <div class="col-md-5">
        <div class="comn-input-select">
            <label class="form-label">From</label>
            <input type="time" class="form-control slot-start-time">
        </div>
    </div>
    <div class="col-md-5">
        <div class="comn-input-select">
            <label class="form-label">To</label>
            <input type="time" class="form-control slot-end-time">
        </div>
    </div>
    <div class="col-md-2 d-flex align-items-end">
        <button type="button" class="btn add-user remove-slot-btn">
            <i class="fa-solid fa-trash"></i>
        </button>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">
<script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>

<script>

var baseUrl = "{{ rtrim(config('app.url'), '/') }}";
let currentProductFilter = 'all';




$(function() {

    $('#bookingTable').DataTable({
        paging: true,
        searching: false, 
        info: true,
        lengthChange: true,
        pageLength: 10,
        ordering: false, 
        language: {
            lengthMenu: 'Show _MENU_ entries',
            paginate: {
                previous: '&laquo;',
                next: '&raquo;'
            }
        },
        dom: '<"top"lf>rt<"bottom"ip><"clear">'
    });

    $('.download-pdf:first').click(function() {
        const date = $('#selected-date').val();
        let url = `${baseUrl}/vendor/calendar/download-pdf/${date}`;
        const params = [];
        
        if (currentProductFilter && currentProductFilter !== 'all') {
            params.push(`product=${encodeURIComponent(currentProductFilter)}`);
        }
        
        const vendorId = $('#vendorSelect').val();
        if (vendorId) {
            params.push(`vendor_id=${encodeURIComponent(vendorId)}`);
        }
        
        if (params.length > 0) {
            url += `?${params.join('&')}`;
        }
        
        window.location.href = url;
    });

    $('.download-pdf:last').click(function() {
        const date = $('#selected-date').val();
        let url = `${baseUrl}/vendor/calendar/download-csv/${date}`;
        const params = [];
        
        if (currentProductFilter && currentProductFilter !== 'all') {
            params.push(`product=${encodeURIComponent(currentProductFilter)}`);
        }
        
        const vendorId = $('#vendorSelect').val();
        if (vendorId) {
            params.push(`vendor_id=${encodeURIComponent(vendorId)}`);
        }
        
        if (params.length > 0) {
            url += `?${params.join('&')}`;
        }
        
        window.location.href = url;
    });

    $("#datepicker").datepicker({
    minDate: 0,
    firstDay: 1, // Monday as the first day of the week
    onSelect: function(dateText) {
        const dateObj = new Date(dateText);
        const formattedDate = $.datepicker.formatDate('yy-mm-dd', dateObj);
        
        $('#selected-date').val(formattedDate);
        $('#selected-date-label').text(
            dateObj.toLocaleDateString('en-US', {
                weekday: 'long', year: 'numeric', month: 'long', day: 'numeric'
            })
        );

        loadAvailabilitySlots(formattedDate);
        loadBookingsForDate(formattedDate, currentProductFilter);
    }
});

    const today = new Date();
    const formattedToday = $.datepicker.formatDate('yy-mm-dd', today);
    $("#datepicker").datepicker("setDate", today);
    $('#selected-date').val(formattedToday);
    $('#selected-date-label').text(
        today.toLocaleDateString('en-US', {
            weekday: 'long', year: 'numeric', month: 'long', day: 'numeric'
        })
    );
    loadAvailabilitySlots(formattedToday);
    loadBookingsForDate(formattedToday);

    $('#add-slot-btn').click(function() {
        $('#full-day-close').prop('checked', false);
        addNewSlot();
    });

    

    $('#save-availability-btn').click(function() {
        saveAvailability();
    });

    $('#full-day-close').change(function() {
        if ($(this).is(':checked')) {
            $('#availability-slots-container').empty();
        }
    });

    function addNewSlot(startTime = '', endTime = '') {
        const $newSlot = $('#slot-template').clone().removeAttr('id').show();
        $newSlot.find('.slot-start-time').val(startTime);
        $newSlot.find('.slot-end-time').val(endTime);
        $('#availability-slots-container').append($newSlot);
        return $newSlot;
    }


    function loadAvailabilitySlots(date) {
        $.get(`${baseUrl}/vendor/calendar/availability/${date}`, function(data) {
            $('#availability-slots-container').empty();
            $('#full-day-close').prop('checked', false);
            
            if (data.length > 0) {
                if (data[0].is_closed) {
                    $('#full-day-close').prop('checked', true);
                } else {
                    data.forEach(slot => {
                        const $newSlot = addNewSlot(slot.start_time, slot.end_time);
                        $newSlot.data('slot-id', slot.id);
                    });
                }
            }
        }).fail(function() {
            $('#availability-slots-container').empty();
            $('#full-day-close').prop('checked', false);
        });
    }

    // function loadBookingsForDate(date, productFilter = null) {
    // $.get(`${baseUrl}/admin/calendar/bookings/${date}`, function(response) {
    //     if (response.success) {
    //         $('.notification-table tbody').html(response.html);
    //                 }
    //             }).fail(function() {
    //                 $('.notification-table tbody').html('<tr><td colspan="8" class="text-center">Failed to load bookings.</td></tr>');
    //             });
    //         }

            function loadBookingsForDate(date, productFilter = null) {
                let url = `${baseUrl}/vendor/calendar/bookings/${date}`;
                
                if (productFilter && productFilter !== 'all') {
                    url += `?product=${encodeURIComponent(productFilter)}`;
                }
                
                $.get(url, function(response) {
                    if (response.success) {
                        $('.notification-table tbody').html(response.html);
                    }
                }).fail(function() {
                    $('.notification-table tbody').html('<tr><td colspan="8" class="text-center">Failed to load bookings.</td></tr>');
                });
            }

            $(document).on('click', '.filter-product', function(e) {
                e.preventDefault();
                currentProductFilter = $(this).data('product');
                const selectedDate = $('#selected-date').val();
                loadBookingsForDate(selectedDate, currentProductFilter);
            });



    function saveAvailability() {
        const date = $('#selected-date').val();
        const isClosed = $('#full-day-close').is(':checked');
        const slots = [];
        
        if (!isClosed) {
            $('.slot-row').each(function() {
                const startTime = $(this).find('.slot-start-time').val();
                const endTime = $(this).find('.slot-end-time').val();
                
                if (startTime && endTime) {
                    slots.push({
                        start_time: startTime,
                        end_time: endTime
                    });
                }
            });
            
            if (slots.length === 0) {
                Swal.fire({
                    icon: 'warning',
                    title: 'No Time Slots',
                    text: 'Please add at least one time slot or mark as closed',
                    confirmButtonText: 'OK'
                });
                return;
            }
        }
        
        const url = isClosed ? `${baseUrl}/vendor/calendar/close-date` : `${baseUrl}/vendor/calendar/store-availability`;
        const data = isClosed ? { date: date } : { date: date, slots: slots };
        
        $.ajax({
            url: url,
            method: 'POST',
            data: {
                ...data,
                _token: '{{ csrf_token() }}'
            },
            success: function(response) {
                Swal.fire({
                    icon: 'success',
                    title: 'Saved!',
                    text: 'Availability saved successfully!',
                    timer: 2000,
                    showConfirmButton: false
                });
                loadAvailabilitySlots(date);
            },
            error: function(xhr) {
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: xhr.responseJSON?.message || 'Error saving availability. Please try again.',
                    confirmButtonText: 'OK'
                });
            }
        });
    }


    $('#availability-slots-container').on('click', '.remove-slot-btn', function() {
        const $slotRow = $(this).closest('.slot-row');
        const slotId = $slotRow.data('slot-id');

        slotToDelete = { $slotRow, slotId };
        $('#deleteProduct').modal('show');
    });

    $('#delete-product-form').off('submit').on('submit', function(e) {
        e.preventDefault();

        const { $slotRow, slotId } = slotToDelete;
        if (!slotId) {
            $slotRow.remove();
            $('#deleteProduct').modal('hide');
            return;
        }

        $.ajax({
            url: `${baseUrl}/vendor/calendar/delete-slot/${slotId}`,
            method: 'DELETE',
            data: { _token: '{{ csrf_token() }}' },
            success: function() {
                $slotRow.remove();
                $('#deleteProduct').modal('hide');
                Swal.fire({
                    icon: 'success',
                    title: 'Deleted!',
                    text: 'Slot deleted successfully',
                    timer: 2000,
                    showConfirmButton: false
                });
            },
            error: function() {
                $('#deleteProduct').modal('hide');
                Swal.fire({
                    icon: 'error',
                    title: 'Failed',
                    text: 'Failed to delete slot',
                    confirmButtonText: 'OK'
                });
            }
        });
    });

    // $('#availability-slots-container').on('click', '.remove-slot-btn', function() {
    //     const $slotRow = $(this).closest('.slot-row');
    //     const slotId = $slotRow.data('slot-id');
        
    //     if (slotId) {
    //         if (confirm('Are you sure you want to delete this slot?')) {
    //             $.ajax({
    //                 url: `${baseUrl}/vendor/calendar/delete-slot/${slotId}`,
    //                 method: 'DELETE',
    //                 data: {
    //                     _token: '{{ csrf_token() }}'
    //                 },
    //                 success: function(response) {
    //                     $slotRow.remove();
    //                     Swal.fire({
    //                         icon: 'success',
    //                         title: 'Deleted!',
    //                         text: 'Slot deleted successfully',
    //                         timer: 2000,
    //                         showConfirmButton: false
    //                     });
    //                 },
    //                 error: function(xhr) {
    //                     Swal.fire({
    //                         icon: 'error',
    //                         title: 'Failed',
    //                         text: 'Failed to delete slot',
    //                         confirmButtonText: 'OK'
    //                     });
    //                 }
    //             });
    //         }
    //     } else {
    //         // If this is a new slot (no ID yet), just remove from DOM
    //         $slotRow.remove();
    //     }
    // });

    $('#inputPassword5').on('keyup', function() {
    const searchValue = $(this).val().toLowerCase();

    $('.notification-table tbody tr').each(function() {
        const productName = $(this).find('td').eq(1).text().toLowerCase();
        const clientName = $(this).find('td').eq(2).text().toLowerCase();
        
        if (productName.includes(searchValue) || clientName.includes(searchValue)) {
            $(this).show();
        } else {
            $(this).hide();
        }
    });
});
$(document).on('change', '.select-active-block', function() {
        const $select = $(this);
        const newStatus = $select.val();
        const bookingId = $select.attr('id').replace('statusSelect', '');
        const currentStatus = $select.find('option:selected').data('previous-value');
        
        if (newStatus === currentStatus) {
            return;
        }
    
        let message = '';
        switch(newStatus) {
            case 'pending':
                message = 'Are you sure you want to set this booking as Pending?';
                break;
            case 'cancelled':
                message = 'Are you sure you want to cancel this booking?';
                break;
            case 'confirmed':
                message = 'Are you sure you want to confirm this booking?';
                break;
            case 'completed':
                message = 'Are you sure you want to mark this booking as Completed?';
                break;
        }
    
        $('#statusChangeModalText').text(message);
        $('#newStatusValue').val(newStatus);
        $('#statusChangeForm').attr('action', `${baseUrl}/vendor/bookings/` + bookingId + '/status');
        
        $('#statusChangeModal').data('select', $select);
        $('#statusChangeModal').data('current-status', currentStatus);
        
        $('#statusChangeModal').modal('show');
    });
    
    $('#statusChangeForm').on('submit', function(e) {
        e.preventDefault();
        
        const form = $(this);
        const url = form.attr('action');
        const $select = $('#statusChangeModal').data('select');
        
        $.ajax({
            url: url,
            type: 'POST',
            data: form.serialize(),
            success: function(response) {
                if(response.success) {
                    $select.find('option:selected').data('previous-value', $('#newStatusValue').val());
                    
                    $('#statusChangeModal').modal('hide'); 
                    Swal.fire({
                            icon: 'success',
                            title: 'Booking Status',
                            text: 'Booking status updated successfully!',
                        }).then((result) => {
                            if (result.isConfirmed) {
                                window.location.reload();
                            }
                        });
                    
                    updateRowStatus($select.closest('tr'), $('#newStatusValue').val());
                }
            },
            error: function(xhr) {
                console.error('Error:', xhr.responseText);
                alert('Error updating booking status. Please try again.');
                
                $select.val($('#statusChangeModal').data('current-status'));
                
                $('#statusChangeModal').modal('hide');
            }
        });
    });
    
    $('#statusChangeModal').on('hidden.bs.modal', function() {
        const $select = $(this).data('select');
        const currentStatus = $(this).data('current-status');
        
        if ($select && currentStatus) {
            $select.val(currentStatus);
        }
    });
    
    function updateRowStatus($row, status) {
        $row.removeClass('table-warning table-success table-danger table-info');
        
        switch(status) {
            case 'pending':
                $row.addClass('table-warning');
                break;
            case 'confirmed':
                $row.addClass('table-info');
                break;
            case 'completed':
                $row.addClass('table-success');
                break;
            case 'cancel':
                $row.addClass('table-danger');
                break;
        }
    }

});
</script>
@endsection